/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.filters;

import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

public class TextFileFilter
implements FileFilter {
    @Override
    public byte[] filter(FileEntry fileEntry) {
        byte[] fileData = fileEntry.getFileData();
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream(fileData.length);
        PrintWriter printWriter = new PrintWriter(byteArray, true);
        for (int offset = 0; offset < fileData.length; ++offset) {
            char c = (char)(fileData[offset] & 0x7F);
            if (c == '\u0000') continue;
            if (c == '\r') {
                printWriter.println();
                continue;
            }
            printWriter.print(c);
        }
        return byteArray.toByteArray();
    }

    @Override
    public String getSuggestedFileName(FileEntry fileEntry) {
        String fileName = fileEntry.getFilename().trim();
        if (!fileName.toLowerCase().endsWith(".txt")) {
            fileName = fileName + ".txt";
        }
        return fileName;
    }
}

